#include "mcc_generated_files/mcc.h"
#include "I2C_LCD.h"

#define i2c_us_dly 1

void i2c_init(void){
    SDA_TRIS = 1; // Hi-Z
    SCL_TRIS = 1; // Hi-Z
}

void i2c_start(void){
    SDA_TRIS = 1; // Hi-Z
    SCL_TRIS = 1; // Hi-Z
    while(!SCL_PORT){};
    __delay_us(i2c_us_dly);
    SDA_TRIS = 0; // Pull down
    __delay_us(i2c_us_dly);
    SCL_TRIS = 0; // Pull down
    __delay_us(i2c_us_dly);
}

void i2c_stop(void){
    SDA_TRIS = 0; // Pull down
    __delay_us(i2c_us_dly);
    SCL_TRIS = 1; // Hi-Z
    __delay_us(i2c_us_dly);
    while(!SCL_PORT){};
    SDA_TRIS = 1; // Hi-Z // Tx stop
    __delay_us(i2c_us_dly);
}

void i2c_8bitTx(uint8_t data) {
    uint8_t p;
#define i2c_delay_usec 10
    p=0x80;
    while(p){
        SCL_TRIS = 0; // Pull down
        if (p & data){
            SDA_TRIS = 1; // Hi-Z
        }
        else{
            SDA_TRIS = 0; // Pull down
        }
        __delay_us(i2c_us_dly);
        p >>= 1;
        SCL_TRIS = 1; // Hi-Z
        while(!SCL_PORT){};
        __delay_us(i2c_us_dly);
    }
    SCL_TRIS = 0; // Pull down
    SDA_TRIS = 1; // Hi-Z
    __delay_us(i2c_us_dly); // ignore slave ack
    SCL_TRIS = 1; // Hi-Z 
    while(!SCL_PORT){};
    __delay_us(i2c_us_dly);
    SCL_TRIS = 0; // Pull down
    __delay_us(i2c_us_dly);
}

//----- 1 character display ----- 
void LCD_dat(char chr){ 
    i2c_start();
    i2c_8bitTx(AQM0802);
    i2c_8bitTx(0x40);
    i2c_8bitTx(chr);
    i2c_stop();
}

//----- command output ----- 
void LCD_cmd(char cmd){
    i2c_start();
    i2c_8bitTx(AQM0802);
    i2c_8bitTx(0x00);
    i2c_8bitTx(cmd);
    i2c_stop();
    if(cmd & 0xFC)      // Instruction with 1 in upper 6 bits
        __delay_us(30); // > 30usec
    else 
       __delay_us(2000); // 2ms Clear and Home command
}

void LCD_posyx(uint8_t ypos, uint8_t xpos){ 
    int pcode; 
    LCD_cmd(0x02); // return home
    __delay_ms(2);
    if (ypos) pcode = 0xC0 + xpos;
    else pcode = 0x80 + xpos;
    LCD_cmd(pcode);
}

//----- string output ----- 
void LCD_str(char * str){
    char *cstart;
    cstart = str;
    while(*str){ // Continue to end of character
        LCD_dat(*str++); // output pointer + 1
        if ((str - cstart) >= LCD_character_length) break;
    }
}

void LCD12_str(char * s1,char * s2){
  LCD_posyx(0,0) ;
    LCD_str(s1) ;
    LCD_posyx(1,0) ;
    LCD_str(s2) ;
}

//----- All clear ----- 
void LCD_clr(void){ 
//    LCD_cmd(0x01);
    const char blank[9] = "         ";
    LCD12_ROMstr(blank,blank);
}

void LCD1_str(char *str){
    LCD_posyx(0,0);
    LCD_str(str);
}

void LCD2_str(char *str){
    LCD_posyx(1,0);
    LCD_str(str);
}

//----- output ROM Characters -----
void LCD_ROMstr(const char *str){ 
    while(*str)
        LCD_dat(*str++);
}

void LCD12_ROMstr(const char *s1,const char *s2){
    LCD_posyx(0,0) ;
    LCD_ROMstr(s1) ;
    LCD_posyx(1,0) ;
    LCD_ROMstr(s2) ;
}

void LCD1_ROMstr(const char *str){
    LCD_posyx(0,0);
    LCD_ROMstr(str);
}

void LCD2_ROMstr(const char *str){
    LCD_posyx(1,0);
    LCD_ROMstr(str);
}

//void LCD_hex(char c){ 
//    const char hexch[] ="0123456789ABCDEF"; 
//    LCD_dat(hexch[c >> 4]);
//    LCD_dat(hexch[c & 0xF]);
//}

void LCD_init(void){ 
    char dat;

    i2c_init();
    
    SCL_SetLow();
    SDA_SetLow();
    
    // AQM0802
    __delay_ms(40); // wait for power stabilize
    LCD_cmd(0x38);
    LCD_cmd(0x39);
    LCD_cmd(0x14); 
    LCD_cmd(0x76); // 0X7 + Contrast Lower 4bit
    LCD_cmd(0x55); // 0x5 + Icon_OFF + Booster_ON(for VDD=3.3V) + contrast set upper 2bit
//    LCD_cmd(0x50); // 0x5 + Icon_OFF + Booster_OFF(for VDD=5V) contrast set upper 2bit
    LCD_cmd(0x6C); // Follower Control
    __delay_ms(20);
    LCD_cmd(0x38);
    LCD_cmd(0x0C); // Display on
    LCD_cmd(0x01); // display clear
    __delay_ms(100);
    
        // AQM1602XA
//    __delay_ms(100); // 100ms wait for power stabilize
//    LCD_cmd(0x39);  // IS = 1 (8/4bit data width�A2/1line�Afont hight*2�Aselect command set:DL=1, N=1, DH=0, IS=1)
//    LCD_cmd(0x14);  // Cursor movement specification
//    LCD_cmd(0x78);  // 0x70�@+�@contrast lowewr 4bit
//    LCD_cmd(0x52);  // 0x50+Icon on/off,Voltage boost off(VDD=5V)+contrast upper 2bit 
//    LCD_cmd(0x6C);  // Follower Control
//    LCD_cmd(0x38);   // IS = 0 (8/4bit data width�A2/1 line�Afont hight*2�Aselect command set:DL=1, N=1, DH=0, IS=0)
//    LCD_cmd(0x0C);   // Display on Cursor=0 Blink=0 
//    LCD_cmd(0x01);   // Clear Display 
//    __delay_ms(2);
//    LCD_cmd(0X02);   // Return Home
//    __delay_ms(2);
//    LCD_cmd(0x06);   // Entry Inc/Dec=1 Shift=0 
//    __delay_ms(2);
}

void ui16toa8(char * s, uint16_t num){
    uint16_t j;
    int8_t p;
    for (p=7;p>=0;p--) {
        j = num%10;
        num = num/10;
        if (num|j|p==7) s[p] = j+'0';
        else s[p] = ' ';
    }
    s[8] = 0;
}

//void i16toa8(char *str, int16_t num){
//    char j;
//    int8_t p,m;
//    if (num < 0){
//        num = -num;
//        m = 1;
//    }
//    else m = 0;
//    for (p=7;p>=0;p--) {
//        j = num%10;
//        num = num/10;
//        if (num|j|(p==7)) str[p] = j+'0';
//        else{
//            if (m) {
//                str[p] = '-';
//                m = 0;
//            }
//            else str[p] = ' ';
//        }
//    }
//    str[8] = 0x00;
//}

