/*  BMTRCTL by ik-gadgets
        Device            :  PIC16F1829
        Driver Version    :  2.00
*/

#include <stdint.h>
#include "mcc_generated_files/mcc.h"
#include "I2C_LCD.h"

/*　memo
 * pwm3 (CCP4) Motor control pwm 0 to 100
 * pwm4 (CCP3) LCD back light control pwm 0 to 100
 * TMR0 interrupt 8msec
 *  */

#define mode_pwm_rpm 0
#define mode_v_rpm 1
#define mode_div_rpm 2
#define mode_keep_rpm 3
#define mode_ave_rpm 4
#define mode_v_lcd 5
#define mode_memory 6

uint8_t mode;
uint8_t temp_mem_mode;

uint8_t motor_on;

int8_t sw_m = 0;
int8_t sw_u = 0;
int8_t sw_d = 0;
int8_t sw_s = 0;

uint8_t tmr0_cnt = 9999;

uint16_t pwm;
uint16_t mV;
uint16_t rpm;
uint8_t BL_mA;
uint16_t target_rpm;
uint8_t rpm_ave_cnt_max;

char strbuf[9];

uint16_t interval_cnt[0xFF];
uint8_t interval_ptr = 0;
#define commutators_number 3
#define commutators_numberX2 6

#define measure_pulse_cnt_max 252
    // 256/commutators_numberX2*commutators_numberX2

#define stop_sum_cnt 40000
    // 80msec/TMR1_clock_period

uint32_t tk;
uint16_t div_k;
uint16_t sw_continue = 0;

#define max_pwm 100

#define LED_Vf_mV 2600
#define LCD_R_all 28
// 28 = Back Light internal 8 ohm + on circuit board 20 ohm

#define MEM_HEAD 0xF000
#define KEY 0xAA55

uint16_t MEM_KEY;

void set_lcd_backlight(uint16_t mV, uint8_t bl_mA) {  
    uint16_t lcd_pwm;
    
    if (mV <= LED_Vf_mV){
        lcd_pwm = max_pwm;
    }
    else{
        lcd_pwm = max_pwm * LCD_R_all;
        lcd_pwm /= mV - LED_Vf_mV;
        lcd_pwm *= BL_mA;
    }
    if (lcd_pwm > max_pwm) lcd_pwm = max_pwm;
    PWM4_LoadDutyValue(lcd_pwm);
}

uint16_t get_mV(void){
    uint32_t temp32;
    temp32 = 1047552;
    temp32 /= ADC_GetConversion(channel_FVR);
    return temp32;
}

uint16_t get_rpm(void){
    static uint8_t prev_ptr = 0;
    uint8_t temp_ptr;
    uint8_t i;
    uint8_t pulse_cnt;
    uint32_t cnt32bit;
    
    if (interval_ptr-prev_ptr == 0){
        return 0;
    }
    prev_ptr = interval_ptr;
    
    cnt32bit = 0;
    temp_ptr = interval_ptr;
    pulse_cnt = 0;
    for(i=0;i<measure_pulse_cnt_max;i++){        
        cnt32bit += interval_cnt[temp_ptr];
        pulse_cnt++;
        if (cnt32bit >= stop_sum_cnt) break;
        temp_ptr--;
    }
    cnt32bit /=　pulse_cnt;
    return tk/cnt32bit;
}

void disp_rpm(uint16_t r){
    static uint8_t ave_cnt = 0;
    static uint32_t sum_rpm = 0;
    if (motor_on == 0){
        LCD2_ROMstr("MotorOFF");
        sum_rpm = 0;
        ave_cnt = 0;
    }
    else{
        sum_rpm += r;
        ave_cnt++;
        if (rpm == 0){
            LCD2_ROMstr("    0RPM");
            sum_rpm = 0;
            ave_cnt = 0;
        }
        else{
            if (ave_cnt >= rpm_ave_cnt_max){ 
                ui16toa8(strbuf, sum_rpm/rpm_ave_cnt_max);
               sum_rpm = 0;
               ave_cnt = 0;
               LCD2_str(strbuf+3);
               LCD_str("RPM");
            }   
        }
    }
}

void ave_rpm(void){
    LCD1_ROMstr("AVE.  ");
    ui16toa8(strbuf, rpm_ave_cnt_max);
    LCD_str(strbuf+6);
    disp_rpm(rpm);
}

void disp_v(uint16_t mV){
    ui16toa8(strbuf, mV);
    strbuf[0] = strbuf[4];
    strbuf[1] = 0x2E;
    strbuf[2] = strbuf[5];
    strbuf[3] = 0x00;
    LCD1_str(strbuf);
    LCD_ROMstr("V    ");
}

void pwm_rpm(void){
    LCD1_ROMstr("PWM");
    ui16toa8(strbuf, pwm);
    LCD_str(strbuf+4);
    LCD_ROMstr("%");
    disp_rpm(rpm);
}

void keep_rpm(void){
    
    ui16toa8(strbuf, target_rpm);
    LCD1_str(strbuf+3);
    LCD_ROMstr("TGT");
    disp_rpm(rpm);
    
    if (motor_on == 0) return;
    if (target_rpm > rpm){
        pwm++;
        if (pwm > max_pwm) pwm = max_pwm;
    }
    else{
        if (pwm > 0) pwm--;
    }
}

void v_rpm(void){
    disp_v(mV);
    disp_rpm(rpm);
}

void set_lcd_contrast(uint16_t mv){
    uint16_t contrast;
    uint8_t i8;
    uint8_t boost_on;
    if (mv > 5000) mv = 5000;
    if (mv <= 4400){
        boost_on = 1;
        contrast = 100352;
        contrast -= mV*21;
    }
    else{
        boost_on = 0;
        contrast = 124921;
        contrast -= mV*24;
    }
    contrast >>= 10;
    if (contrast > 63) contrast = 63;

    LCD_cmd(0x38); // LCD commandmode setting
    LCD_cmd(0x39); // LCD commandmode setting
    i8 = contrast & 0xF;
    i8 += 0x70; 
    LCD_cmd(i8); // 0X7 + Contrast Lower 4bit
    i8 = contrast >> 4;
    if (boost_on) i8 += 4;
    i8 += 0x50;
    LCD_cmd(i8); // 0x5 + Icon_OFF + Booster_ON + contrast set upper 2bit
}

void div_rpm(void){
    LCD1_ROMstr("RPM\xF8");
    ui16toa8(strbuf, div_k);
    LCD_str(strbuf+4);
    disp_rpm(rpm/div_k);
}

void v_lcd(void){
    disp_v(mV);
    ui16toa8(strbuf, BL_mA);
    LCD2_ROMstr("LCD ");
    LCD_str(strbuf+6);
    LCD_ROMstr("mA");
}

uint16_t up_data(uint16_t data,uint16_t max,uint16_t cont){
    uint16_t delta;
    uint16_t new;
    if (cont < 300){
        new = data + 1;
    }
    else{
        if (cont < 600) delta = 10;
        else if (cont < 900) delta = 100;
        else delta = 1000;
        new = data + delta;
        new /= delta;
        new *= delta;
    }
    if (new > max) new = max;
    return new;
}

uint16_t down_data(uint16_t data,uint16_t min,uint16_t cont){
    uint16_t delta;
    uint16_t new;
    if (cont < 300) delta = 1;
    else if (cont < 600) delta = 10;
    else if (cont < 900) delta = 100;
    else delta = 1000;
    if (data > (min + delta)){
        new = data - delta;
        if (delta > 1){
            new /= delta;
            new *= delta; 
        }
    }
    else new = min;
    return new;
}

uint16_t DATAEE_ReadWord(uint16_t addr){
    uint16_t i;
    i = DATAEE_ReadByte(addr);
    i <<= 8;
    i +=DATAEE_ReadByte(addr+1);
    return i;
}

void DATAEE_WriteWord(uint16_t addr,uint16_t data){
    if (DATAEE_ReadWord(addr) != data){
        DATAEE_WriteByte(addr,data>>8);
        DATAEE_WriteByte(addr+1,data&0xFF);
    }
}

void Write_Parameters(void){
    uint16_t ptr;
    ptr = MEM_HEAD;
    DATAEE_WriteWord(ptr,MEM_KEY);
    ptr += 2;
    DATAEE_WriteWord(ptr,mode);
    ptr += 2;
    DATAEE_WriteWord(ptr,motor_on);
    ptr += 2;
    DATAEE_WriteWord(ptr,pwm);
    ptr += 2;
    DATAEE_WriteWord(ptr,target_rpm);
    ptr += 2;
    DATAEE_WriteWord(ptr,div_k);
    ptr += 2;
    DATAEE_WriteWord(ptr,BL_mA);
    ptr += 2;
    DATAEE_WriteWord(ptr,rpm_ave_cnt_max);
}

void Read_Parameters(void){
    uint16_t ptr;
    ptr = MEM_HEAD;
    MEM_KEY = DATAEE_ReadWord(ptr);
    ptr += 2;
    mode = DATAEE_ReadWord(ptr);
    ptr += 2;
    motor_on = DATAEE_ReadWord(ptr);
    ptr += 2;
    pwm = DATAEE_ReadWord(ptr);
    ptr += 2;
    target_rpm = DATAEE_ReadWord(ptr);
    ptr += 2;
    div_k = DATAEE_ReadWord(ptr);
    ptr += 2;
    BL_mA = DATAEE_ReadWord(ptr);
    ptr += 2;
    rpm_ave_cnt_max = DATAEE_ReadWord(ptr);
}

void memory(void){
    LCD1_ROMstr("REMEMBER");
    switch (temp_mem_mode){
        case mode_pwm_rpm: LCD2_ROMstr(" PWM_RPM");break;
        case mode_v_rpm: LCD2_ROMstr("   V_RPM");break;
        case mode_div_rpm: LCD2_ROMstr(" DIV_RPM");break;
        case mode_v_lcd: LCD2_ROMstr("V_LCD_mA");break;
        case mode_keep_rpm: LCD2_ROMstr("KEEP_RPM");break;
        case mode_ave_rpm: LCD2_ROMstr("AVERAGE ");break;
        case mode_memory: LCD2_ROMstr("  MEMORY");break;
    }
}

void main(void)
{
    uint16_t cnt = 0;
    uint16_t cnt_prev = 0;
    uint16_t delta;
    uint16_t sum=0;
    uint8_t loop_cnt = 0;
    
    // initialize the device
    SYSTEM_Initialize();

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

    LCD_init();

    tk = 30000000/commutators_numberX2; // 3000000 = 60sec/ TMR1 clock period
    for (uint16_t i=0;i<=0xFF;i++) interval_cnt[i] = 0xFF;

    MEM_KEY = DATAEE_ReadWord(MEM_HEAD);
    if (MEM_KEY != KEY){
        MEM_KEY = KEY;
        mode = mode_pwm_rpm;
        motor_on = 0;
        pwm = 0;
        target_rpm = 0;
        div_k = 10;
        BL_mA = 25;
        rpm_ave_cnt_max = 8;
        Write_Parameters();
    }
    else{
        Read_Parameters();
    }
    temp_mem_mode = mode;

    while (1)
    {
        if (tmr0_cnt >= 10) tmr0_cnt = 0;
        else continue;
        
        rpm = get_rpm();

        if (sw_m > 0){
            sw_m -= 50;
            switch(mode){
                case mode_pwm_rpm:mode = mode_keep_rpm;break;
                case mode_keep_rpm:mode = mode_v_rpm;break;
                case mode_v_rpm:mode = mode_div_rpm;break;
                case mode_div_rpm:mode = mode_v_lcd;break;
                case mode_v_lcd:mode = mode_ave_rpm;break;
                case mode_ave_rpm:mode = mode_memory;break;
                case mode_memory:mode = mode_pwm_rpm;break;
                default: mode = mode_pwm_rpm;
            }
        }
        if (sw_s > 0){
            sw_s = -50;
            if (mode <= mode_ave_rpm){
                if (motor_on) motor_on = 0;
                else motor_on = 1;
            }
            else if (mode == mode_memory){
                mode = temp_mem_mode;
                Write_Parameters();
                mode = mode_memory;
            }
        }
        if (sw_u > 0){
            sw_u = -20;
            if (mode < mode_div_rpm){
                pwm = up_data(pwm,max_pwm,sw_continue);
            }
            else if (mode == mode_keep_rpm){
                target_rpm = up_data(target_rpm,65000,sw_continue);
            }
            else if (mode == mode_div_rpm){
                div_k = up_data(div_k,9999,sw_continue);
            }
            else if (mode == mode_v_lcd){
                if (BL_mA < 30) BL_mA++;
            }
            else if (mode == mode_ave_rpm){
                if (rpm_ave_cnt_max < 25) rpm_ave_cnt_max++;
            }
            else if (mode == mode_memory){
                temp_mem_mode++;
                if (temp_mem_mode > mode_memory) temp_mem_mode = mode_pwm_rpm;
            }
        }
        if (sw_d > 0){
            sw_d = -20;
            if (mode < mode_div_rpm){
                pwm = down_data(pwm,0,sw_continue);
            }
            else if (mode == mode_keep_rpm){
                target_rpm = down_data(target_rpm,0,sw_continue);
            }
            else if (mode == mode_div_rpm){
                div_k = down_data(div_k,1,sw_continue);
            }
            else if (mode == mode_v_lcd){
                if (BL_mA > 0) BL_mA--;
            }
            else if (mode == mode_ave_rpm){
                if (rpm_ave_cnt_max > 1) rpm_ave_cnt_max--;
            }
            else if (mode == mode_memory){
                if (temp_mem_mode == 0) temp_mem_mode = mode_memory;
                else temp_mem_mode--;
            }
        }
 
        mV = get_mV();
        set_lcd_contrast(mV);
        set_lcd_backlight(mV,BL_mA);
        if (motor_on == 0){
            PWM3_LoadDutyValue(0);
        }
        else{
            PWM3_LoadDutyValue(pwm);
        }
        switch(mode){
            case mode_pwm_rpm:pwm_rpm();break;
            case mode_keep_rpm:keep_rpm();break;
            case mode_v_rpm:v_rpm();break;
            case mode_div_rpm:div_rpm();break;
            case mode_ave_rpm:ave_rpm();break;
            case mode_v_lcd:v_lcd();break;
            case mode_memory:memory();break;
        }
    }
}

/**
 End of File
*/
