#include "mcc.h"

extern uint16_t interval_cnt[0xFF];
extern uint8_t interval_ptr;

extern int8_t sw_m;
extern int8_t sw_s;
extern int8_t sw_u;
extern int8_t sw_d;
extern uint8_t tmr0_cnt;
extern uint16_t sw_continue;
uint16_t new_TMR1 = 0;
static uint16_t prev_TMR1 = 0;


void __interrupt() INTERRUPT_InterruptManager (void)
{
    if(PIR2bits.C1IF == 1){
        if(PIE2bits.C1IE == 1 && INTCONbits.PEIE == 1){
            CMP1_ISR();
            interval_ptr++;
            new_TMR1 = TMR1_ReadTimer();
            interval_cnt[interval_ptr] = new_TMR1 - prev_TMR1;
            prev_TMR1 = new_TMR1;
        }
    }
    if(INTCONbits.TMR0IE == 1 && INTCONbits.TMR0IF == 1){
        TMR0_ISR();
        tmr0_cnt++;
        if (SW_U_PORT==0){
            sw_u++;
            sw_continue++;
        }
        else if (SW_D_PORT==0){
            sw_d++;
            sw_continue++;
        }
        else if (SW_M_PORT==0){
            sw_m++;
        }
        else if (SW_S_PORT==0){
            sw_s++;
        }
        else{
            sw_u = 0;
            sw_d = 0;
            sw_m = 0;
            sw_s = 0;
            sw_continue = 0;
        }
    }
}
/**
 End of File
*/
