/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.8
        Device            :  PIC16F1829
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.36 and above
        MPLAB 	          :  MPLAB X 6.00	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set RA0 procedures
#define RA0_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define RA0_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define RA0_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define RA0_GetValue()              PORTAbits.RA0
#define RA0_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define RA0_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define RA0_SetPullup()             do { WPUAbits.WPUA0 = 1; } while(0)
#define RA0_ResetPullup()           do { WPUAbits.WPUA0 = 0; } while(0)
#define RA0_SetAnalogMode()         do { ANSELAbits.ANSA0 = 1; } while(0)
#define RA0_SetDigitalMode()        do { ANSELAbits.ANSA0 = 0; } while(0)

// get/set RA2 procedures
#define RA2_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define RA2_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define RA2_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define RA2_GetValue()              PORTAbits.RA2
#define RA2_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define RA2_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define RA2_SetPullup()             do { WPUAbits.WPUA2 = 1; } while(0)
#define RA2_ResetPullup()           do { WPUAbits.WPUA2 = 0; } while(0)
#define RA2_SetAnalogMode()         do { ANSELAbits.ANSA2 = 1; } while(0)
#define RA2_SetDigitalMode()        do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set SCL aliases
#define SCL_TRIS                 TRISAbits.TRISA4
#define SCL_LAT                  LATAbits.LATA4
#define SCL_PORT                 PORTAbits.RA4
#define SCL_WPU                  WPUAbits.WPUA4
#define SCL_ANS                  ANSELAbits.ANSA4
#define SCL_SetHigh()            do { LATAbits.LATA4 = 1; } while(0)
#define SCL_SetLow()             do { LATAbits.LATA4 = 0; } while(0)
#define SCL_Toggle()             do { LATAbits.LATA4 = ~LATAbits.LATA4; } while(0)
#define SCL_GetValue()           PORTAbits.RA4
#define SCL_SetDigitalInput()    do { TRISAbits.TRISA4 = 1; } while(0)
#define SCL_SetDigitalOutput()   do { TRISAbits.TRISA4 = 0; } while(0)
#define SCL_SetPullup()          do { WPUAbits.WPUA4 = 1; } while(0)
#define SCL_ResetPullup()        do { WPUAbits.WPUA4 = 0; } while(0)
#define SCL_SetAnalogMode()      do { ANSELAbits.ANSA4 = 1; } while(0)
#define SCL_SetDigitalMode()     do { ANSELAbits.ANSA4 = 0; } while(0)

// get/set SW_D aliases
#define SW_D_TRIS                 TRISAbits.TRISA5
#define SW_D_LAT                  LATAbits.LATA5
#define SW_D_PORT                 PORTAbits.RA5
#define SW_D_WPU                  WPUAbits.WPUA5
#define SW_D_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define SW_D_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define SW_D_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define SW_D_GetValue()           PORTAbits.RA5
#define SW_D_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define SW_D_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define SW_D_SetPullup()          do { WPUAbits.WPUA5 = 1; } while(0)
#define SW_D_ResetPullup()        do { WPUAbits.WPUA5 = 0; } while(0)

// get/set VDD1 aliases
#define VDD1_TRIS                 TRISBbits.TRISB4
#define VDD1_LAT                  LATBbits.LATB4
#define VDD1_PORT                 PORTBbits.RB4
#define VDD1_WPU                  WPUBbits.WPUB4
#define VDD1_ANS                  ANSELBbits.ANSB4
#define VDD1_SetHigh()            do { LATBbits.LATB4 = 1; } while(0)
#define VDD1_SetLow()             do { LATBbits.LATB4 = 0; } while(0)
#define VDD1_Toggle()             do { LATBbits.LATB4 = ~LATBbits.LATB4; } while(0)
#define VDD1_GetValue()           PORTBbits.RB4
#define VDD1_SetDigitalInput()    do { TRISBbits.TRISB4 = 1; } while(0)
#define VDD1_SetDigitalOutput()   do { TRISBbits.TRISB4 = 0; } while(0)
#define VDD1_SetPullup()          do { WPUBbits.WPUB4 = 1; } while(0)
#define VDD1_ResetPullup()        do { WPUBbits.WPUB4 = 0; } while(0)
#define VDD1_SetAnalogMode()      do { ANSELBbits.ANSB4 = 1; } while(0)
#define VDD1_SetDigitalMode()     do { ANSELBbits.ANSB4 = 0; } while(0)

// get/set IN aliases
#define IN_TRIS                 TRISBbits.TRISB6
#define IN_LAT                  LATBbits.LATB6
#define IN_PORT                 PORTBbits.RB6
#define IN_WPU                  WPUBbits.WPUB6
#define IN_SetHigh()            do { LATBbits.LATB6 = 1; } while(0)
#define IN_SetLow()             do { LATBbits.LATB6 = 0; } while(0)
#define IN_Toggle()             do { LATBbits.LATB6 = ~LATBbits.LATB6; } while(0)
#define IN_GetValue()           PORTBbits.RB6
#define IN_SetDigitalInput()    do { TRISBbits.TRISB6 = 1; } while(0)
#define IN_SetDigitalOutput()   do { TRISBbits.TRISB6 = 0; } while(0)
#define IN_SetPullup()          do { WPUBbits.WPUB6 = 1; } while(0)
#define IN_ResetPullup()        do { WPUBbits.WPUB6 = 0; } while(0)

// get/set SW_S aliases
#define SW_S_TRIS                 TRISBbits.TRISB7
#define SW_S_LAT                  LATBbits.LATB7
#define SW_S_PORT                 PORTBbits.RB7
#define SW_S_WPU                  WPUBbits.WPUB7
#define SW_S_SetHigh()            do { LATBbits.LATB7 = 1; } while(0)
#define SW_S_SetLow()             do { LATBbits.LATB7 = 0; } while(0)
#define SW_S_Toggle()             do { LATBbits.LATB7 = ~LATBbits.LATB7; } while(0)
#define SW_S_GetValue()           PORTBbits.RB7
#define SW_S_SetDigitalInput()    do { TRISBbits.TRISB7 = 1; } while(0)
#define SW_S_SetDigitalOutput()   do { TRISBbits.TRISB7 = 0; } while(0)
#define SW_S_SetPullup()          do { WPUBbits.WPUB7 = 1; } while(0)
#define SW_S_ResetPullup()        do { WPUBbits.WPUB7 = 0; } while(0)

// get/set VDD2 aliases
#define VDD2_TRIS                 TRISCbits.TRISC1
#define VDD2_LAT                  LATCbits.LATC1
#define VDD2_PORT                 PORTCbits.RC1
#define VDD2_WPU                  WPUCbits.WPUC1
#define VDD2_ANS                  ANSELCbits.ANSC1
#define VDD2_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define VDD2_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define VDD2_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define VDD2_GetValue()           PORTCbits.RC1
#define VDD2_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define VDD2_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)
#define VDD2_SetPullup()          do { WPUCbits.WPUC1 = 1; } while(0)
#define VDD2_ResetPullup()        do { WPUCbits.WPUC1 = 0; } while(0)
#define VDD2_SetAnalogMode()      do { ANSELCbits.ANSC1 = 1; } while(0)
#define VDD2_SetDigitalMode()     do { ANSELCbits.ANSC1 = 0; } while(0)

// get/set CNT aliases
#define CNT_TRIS                 TRISCbits.TRISC2
#define CNT_LAT                  LATCbits.LATC2
#define CNT_PORT                 PORTCbits.RC2
#define CNT_WPU                  WPUCbits.WPUC2
#define CNT_ANS                  ANSELCbits.ANSC2
#define CNT_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define CNT_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define CNT_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define CNT_GetValue()           PORTCbits.RC2
#define CNT_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define CNT_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define CNT_SetPullup()          do { WPUCbits.WPUC2 = 1; } while(0)
#define CNT_ResetPullup()        do { WPUCbits.WPUC2 = 0; } while(0)
#define CNT_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define CNT_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set SW_M aliases
#define SW_M_TRIS                 TRISCbits.TRISC3
#define SW_M_LAT                  LATCbits.LATC3
#define SW_M_PORT                 PORTCbits.RC3
#define SW_M_WPU                  WPUCbits.WPUC3
#define SW_M_ANS                  ANSELCbits.ANSC3
#define SW_M_SetHigh()            do { LATCbits.LATC3 = 1; } while(0)
#define SW_M_SetLow()             do { LATCbits.LATC3 = 0; } while(0)
#define SW_M_Toggle()             do { LATCbits.LATC3 = ~LATCbits.LATC3; } while(0)
#define SW_M_GetValue()           PORTCbits.RC3
#define SW_M_SetDigitalInput()    do { TRISCbits.TRISC3 = 1; } while(0)
#define SW_M_SetDigitalOutput()   do { TRISCbits.TRISC3 = 0; } while(0)
#define SW_M_SetPullup()          do { WPUCbits.WPUC3 = 1; } while(0)
#define SW_M_ResetPullup()        do { WPUCbits.WPUC3 = 0; } while(0)
#define SW_M_SetAnalogMode()      do { ANSELCbits.ANSC3 = 1; } while(0)
#define SW_M_SetDigitalMode()     do { ANSELCbits.ANSC3 = 0; } while(0)

// get/set GND aliases
#define GND_TRIS                 TRISCbits.TRISC4
#define GND_LAT                  LATCbits.LATC4
#define GND_PORT                 PORTCbits.RC4
#define GND_WPU                  WPUCbits.WPUC4
#define GND_SetHigh()            do { LATCbits.LATC4 = 1; } while(0)
#define GND_SetLow()             do { LATCbits.LATC4 = 0; } while(0)
#define GND_Toggle()             do { LATCbits.LATC4 = ~LATCbits.LATC4; } while(0)
#define GND_GetValue()           PORTCbits.RC4
#define GND_SetDigitalInput()    do { TRISCbits.TRISC4 = 1; } while(0)
#define GND_SetDigitalOutput()   do { TRISCbits.TRISC4 = 0; } while(0)
#define GND_SetPullup()          do { WPUCbits.WPUC4 = 1; } while(0)
#define GND_ResetPullup()        do { WPUCbits.WPUC4 = 0; } while(0)

// get/set SDA aliases
#define SDA_TRIS                 TRISCbits.TRISC5
#define SDA_LAT                  LATCbits.LATC5
#define SDA_PORT                 PORTCbits.RC5
#define SDA_WPU                  WPUCbits.WPUC5
#define SDA_SetHigh()            do { LATCbits.LATC5 = 1; } while(0)
#define SDA_SetLow()             do { LATCbits.LATC5 = 0; } while(0)
#define SDA_Toggle()             do { LATCbits.LATC5 = ~LATCbits.LATC5; } while(0)
#define SDA_GetValue()           PORTCbits.RC5
#define SDA_SetDigitalInput()    do { TRISCbits.TRISC5 = 1; } while(0)
#define SDA_SetDigitalOutput()   do { TRISCbits.TRISC5 = 0; } while(0)
#define SDA_SetPullup()          do { WPUCbits.WPUC5 = 1; } while(0)
#define SDA_ResetPullup()        do { WPUCbits.WPUC5 = 0; } while(0)

// get/set RC6 procedures
#define RC6_SetHigh()            do { LATCbits.LATC6 = 1; } while(0)
#define RC6_SetLow()             do { LATCbits.LATC6 = 0; } while(0)
#define RC6_Toggle()             do { LATCbits.LATC6 = ~LATCbits.LATC6; } while(0)
#define RC6_GetValue()              PORTCbits.RC6
#define RC6_SetDigitalInput()    do { TRISCbits.TRISC6 = 1; } while(0)
#define RC6_SetDigitalOutput()   do { TRISCbits.TRISC6 = 0; } while(0)
#define RC6_SetPullup()             do { WPUCbits.WPUC6 = 1; } while(0)
#define RC6_ResetPullup()           do { WPUCbits.WPUC6 = 0; } while(0)
#define RC6_SetAnalogMode()         do { ANSELCbits.ANSC6 = 1; } while(0)
#define RC6_SetDigitalMode()        do { ANSELCbits.ANSC6 = 0; } while(0)

// get/set SW_U aliases
#define SW_U_TRIS                 TRISCbits.TRISC7
#define SW_U_LAT                  LATCbits.LATC7
#define SW_U_PORT                 PORTCbits.RC7
#define SW_U_WPU                  WPUCbits.WPUC7
#define SW_U_ANS                  ANSELCbits.ANSC7
#define SW_U_SetHigh()            do { LATCbits.LATC7 = 1; } while(0)
#define SW_U_SetLow()             do { LATCbits.LATC7 = 0; } while(0)
#define SW_U_Toggle()             do { LATCbits.LATC7 = ~LATCbits.LATC7; } while(0)
#define SW_U_GetValue()           PORTCbits.RC7
#define SW_U_SetDigitalInput()    do { TRISCbits.TRISC7 = 1; } while(0)
#define SW_U_SetDigitalOutput()   do { TRISCbits.TRISC7 = 0; } while(0)
#define SW_U_SetPullup()          do { WPUCbits.WPUC7 = 1; } while(0)
#define SW_U_ResetPullup()        do { WPUCbits.WPUC7 = 0; } while(0)
#define SW_U_SetAnalogMode()      do { ANSELCbits.ANSC7 = 1; } while(0)
#define SW_U_SetDigitalMode()     do { ANSELCbits.ANSC7 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/