/**
  Switc Timer
    2023/07/11
 by IK-gadgets
*/

#include "mcc_generated_files/mcc.h"
#include "I2C_LCD.h"

#define tstate_off_minute 0
#define tstate_off_hour 1
#define tstate_on_minute 2
#define tstate_on_hour 3
#define tstate_off_second 4
#define tstate_on_second 5
uint8_t tstate = tstate_off_minute;

#define cstate_stop 0
#define cstate_count 1
# define cstate_wait 3
uint8_t cstate = cstate_stop;

uint8_t SSR_on_flag = 0;
uint8_t SSR_on_flag_prev = 0;

uint8_t tmr0_flag = 0; // set by TMR0(f=32,period=31.25msec)
uint8_t tmr0_cnt = 0;
int8_t time_on[] = {0,0,0};
uint8_t time_on_0_flag = 1;
uint8_t time_on_0_flag_prev = 1;
int8_t time_off[] = {0,0,0};
uint8_t time_off_0_flag = 1;
uint8_t time_off_0_flag_prev = 1;
int8_t add_time[3];
int8_t plusminus[3];
const int8_t PLUS_S[] = {0,0,1};
const int8_t PLUS_M[] = {0,1,0};
const int8_t PLUS_H[] = {1,0,0};
const int8_t MINUS_S[] = {0,0,-1};

uint16_t sw_plus_cnt = 0;
uint16_t sw_plus_cnt_prev = 0;
uint16_t sw_minus_cnt = 0;
uint16_t sw_minus_cnt_prev = 0;
uint8_t sw_select = 0;
uint8_t sw_select_prev = 0;
uint8_t sw_start = 0;
uint8_t sw_start_prev = 0;
uint8_t sw_stop = 0;
uint8_t sw_stop_prev = 0;

#define LED_ON 500
#define LED_OFF 0
#define BUZZER_ON 250

uint8_t strbuf[9];
const uint8_t CHR_LA[] = {0x08,0x00}; //<--
const uint8_t CHR_RA[] = {0x07,0x00}; // -->
uint8_t time;

void disp_time(int8_t* hms,uint8_t ud){
    HMStoa2(strbuf, hms[0]);
    if (ud == 1) LCD1_str(strbuf);
    else LCD2_str(strbuf);
    
    if (ud == 1){
        if (tstate == tstate_on_hour) LCD_ROMstr(CHR_LA); // <-
        else LCD_ROMstr(":");
    }
    else{
        if (tstate == tstate_off_hour) LCD_ROMstr(CHR_LA); // <-
        else LCD_ROMstr(":");
    }
    
    HMStoa2(strbuf, hms[1]);
    LCD_str(strbuf);
    
    if (ud == 1){
        if (tstate == tstate_on_minute) LCD_ROMstr(CHR_LA); // <-
        else if (tstate == tstate_on_second) LCD_ROMstr(CHR_RA);
        else LCD_ROMstr(":");
    }
    else{
        if (tstate==tstate_off_minute) LCD_ROMstr(CHR_LA); // <-
        else if (tstate == tstate_off_second) LCD_ROMstr(CHR_RA); // ->
        else LCD_ROMstr(":");
    }
    HMStoa2(strbuf, hms[2]);
    LCD_str(strbuf);
}

uint8_t time_update(int8_t* p1,int8_t* p2){ // p2[] = p1[] + p2[], return = time_0_flag
    int8_t temp;
    temp = p1[2] + p2[2];
    if (temp >= 60){
        p2[1]++;
        p2[2] = temp - 60;
    }
    else if (temp < 0){
        p2[1]--;
        p2[2] = temp + 60;
    }
    else{
        p2[2] = temp;
    }
    temp = p1[1] + p2[1];
    if (temp >= 60){
        p2[0]++;
        p2[1] = temp - 60;
    }
    else if (temp < 0){
        p2[0]--;
        p2[1] = temp + 60;
    }
    else{
        p2[1] = temp;
    }
    temp = p1[0] + p2[0];
    if (temp < 0){
        p2[0] = 0;
        p2[1] = 0;
        p2[2] = 0;
    }
    else{
        p2[0] = temp;
    }
    if (p2[2] == 0 & p2[1] == 0 & p2[0] == 0) return 1;
    else return 0;
}

uint8_t time_0_check(int8_t* p){ //return = time_0_flag
    if (p[2] == 0 && p[1] == 0 && p[0] == 0) return 1;
    else return 0;
}

uint8_t time_compare(int8_t* p1,int8_t* p2){ //p1>p2:1 p1=p2:0 p1<p2:-1 1
    if (p1[0] > p2[0]) return 1;
    else if (p1[0] < p2[0]) return -1;
    if (p1[1] > p2[1]) return 1;
    else if (p1[1] < p2[1]) return -1;
    if (p1[2] > p2[2]) return 1;
    else if (p1[2] < p2[2]) return -1;
    else return 0;
}

void time_reset(int8_t* p){
    p[0] = 0;
    p[1] = 0;
    p[2] = 0;
}

void check_sw(){
    sw_select_prev = sw_select;
    sw_select = !SELECT_PORT;
    sw_start_prev = sw_start;
    sw_start = !START_PORT;
    sw_stop_prev = sw_stop;
    sw_stop = !STOP_PORT;
    
    sw_plus_cnt_prev = sw_plus_cnt;
    if (PLUS_PORT){
        sw_plus_cnt = 0; 
    }
    else{
        sw_plus_cnt++;
        if (sw_plus_cnt >= 260){
            sw_plus_cnt = 250;
            sw_plus_cnt_prev = 0;
        }
        else if (sw_plus_cnt % 25 == 0){
            sw_plus_cnt_prev = 0;
        }
    }
    sw_minus_cnt_prev = sw_minus_cnt;
    if (MINUS_PORT){
        sw_minus_cnt = 0; 
    }
    else{
        sw_minus_cnt++;
        if (sw_minus_cnt >= 260){
            sw_minus_cnt = 250;
            sw_minus_cnt_prev = 0;
        }
        else if (sw_minus_cnt % 25 == 0){
            sw_minus_cnt_prev = 0;
        }
    }
}

void beep(){
    PWM5_LoadDutyValue(BUZZER_ON);
    __delay_ms(100);
    if (SSR_on_flag) PWM5_LoadDutyValue(LED_ON);
    else PWM5_LoadDutyValue(LED_OFF);
}

void set_SSR_on(){
    SSR_on_flag = 1;
    SSRCTL_SetLow();
    PWM5_LoadDutyValue(LED_ON);
}

void set_SSR_off(){
    SSR_on_flag = 0;
    SSRCTL_SetHigh();
    PWM5_LoadDutyValue(LED_OFF);
}

void main(void)
{
    int8_t plusminus;
    int8_t i;
    uint8_t wait_cnt = 0;
    
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();
    
    LCD_init();

    while (1)
    {   
        if (tmr0_flag){ // interruppt each 10msec?
            tmr0_flag = 0;
            tmr0_cnt++;
 
            check_sw();

            if (sw_select && !sw_select_prev){
                tstate++;
                if (tstate > 5) tstate = 0;
                disp_time(time_on,1);
                disp_time(time_off,2);
            }
            
            if (sw_start && !sw_start_prev){
                cstate = cstate_count;
                tmr0_cnt = 0;
                time_on_0_flag = time_0_check(time_on);
                time_on_0_flag_prev = time_on_0_flag;
                time_off_0_flag = time_0_check(time_off);
                time_off_0_flag_prev = time_off_0_flag;
                
                if (time_on_0_flag && !time_off_0_flag) set_SSR_on();
                else if (!time_on_0_flag && time_off_0_flag) set_SSR_off();
                else if (time_on_0_flag && time_off_0_flag) cstate = cstate_stop;
                else{
                    i = time_compare(time_on,time_off);
                    if (i > 0) set_SSR_on();
                    else if (i < 0) set_SSR_off();
                    else{
                        set_SSR_off();
                        cstate = cstate_stop;
                        time_reset(time_on);
                        time_reset(time_off);
                    }
                }
   
                disp_time(time_on,1);
                disp_time(time_off,2);
            }
            
            if (sw_stop && !sw_stop_prev){
                if (cstate != cstate_count){
                    set_SSR_off();
                    cstate = cstate_stop;
                    time_reset(time_on);
                    time_reset(time_off);
                }
                else{
                    cstate = cstate_wait;
                }
            }
            
            if (sw_plus_cnt && !sw_plus_cnt_prev) plusminus = 1;
            else if (sw_minus_cnt && !sw_minus_cnt_prev) plusminus = -1;
            else plusminus = 0;
            if (plusminus != 0){
                add_time[0] = 0;
                add_time[1] = 0;
                add_time[2] = 0;
                switch (tstate){
                    case tstate_off_minute:
                        add_time[1] = plusminus;
                        time_update(add_time,time_off);
                        disp_time(time_off,2);
                        break;
                    case tstate_off_hour:
                        add_time[0] = plusminus;
                        time_update(add_time,time_off);
                        disp_time(time_off,2);
                        break;
                    case tstate_off_second:
                        add_time[2] = plusminus;
                        time_update(add_time,time_off);
                        disp_time(time_off,2);
                        break;
                    case tstate_on_minute:
                        add_time[1] = plusminus;
                        time_update(add_time,time_on);
                        disp_time(time_on,1);
                        break;
                    case tstate_on_hour:
                        add_time[0] = plusminus;
                        time_update(add_time,time_on);
                        disp_time(time_on,1);
                        break;
                    case tstate_on_second:
                        add_time[2] = plusminus;
                        time_update(add_time,time_on);
                        disp_time(time_on,1);
                        break;
                }
            }
        }
        
        if (tmr0_cnt >=100){ // 1 sec period
            tmr0_cnt = 0;
            if (cstate == cstate_count){
                time_off_0_flag = time_update(MINUS_S,time_off);
                time_on_0_flag = time_update(MINUS_S,time_on);
                if (time_off_0_flag && !time_off_0_flag_prev){
                    set_SSR_off();
                }
                if (time_on_0_flag && !time_on_0_flag_prev){
                    set_SSR_on();
                }
                if (time_on_0_flag && time_off_0_flag){
                    cstate = cstate_stop;
                }
                time_off_0_flag_prev = time_off_0_flag;
                time_on_0_flag_prev = time_on_0_flag;
            }
            disp_time(time_on,1);
            disp_time(time_off,2);

            if (cstate == cstate_wait){
                wait_cnt++;
                wait_cnt &= 0x01;
                if (wait_cnt){
                    LCD1_ROMstr("Waiting ");
                    disp_time(time_off,2);
                }
                else{
                    LCD2_ROMstr("Waiting ");
                    disp_time(time_on,1);
                }
            }
        }
        
        if (SSR_on_flag != SSR_on_flag_prev){
            SSR_on_flag_prev = SSR_on_flag;
            beep();
        }
    }
}
