/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.8
        Device            :  PIC16F18325
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.36 and above
        MPLAB 	          :  MPLAB X 6.00	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set PLUS aliases
#define PLUS_TRIS                 TRISAbits.TRISA0
#define PLUS_LAT                  LATAbits.LATA0
#define PLUS_PORT                 PORTAbits.RA0
#define PLUS_WPU                  WPUAbits.WPUA0
#define PLUS_OD                   ODCONAbits.ODCA0
#define PLUS_ANS                  ANSELAbits.ANSA0
#define PLUS_SetHigh()            do { LATAbits.LATA0 = 1; } while(0)
#define PLUS_SetLow()             do { LATAbits.LATA0 = 0; } while(0)
#define PLUS_Toggle()             do { LATAbits.LATA0 = ~LATAbits.LATA0; } while(0)
#define PLUS_GetValue()           PORTAbits.RA0
#define PLUS_SetDigitalInput()    do { TRISAbits.TRISA0 = 1; } while(0)
#define PLUS_SetDigitalOutput()   do { TRISAbits.TRISA0 = 0; } while(0)
#define PLUS_SetPullup()          do { WPUAbits.WPUA0 = 1; } while(0)
#define PLUS_ResetPullup()        do { WPUAbits.WPUA0 = 0; } while(0)
#define PLUS_SetPushPull()        do { ODCONAbits.ODCA0 = 0; } while(0)
#define PLUS_SetOpenDrain()       do { ODCONAbits.ODCA0 = 1; } while(0)
#define PLUS_SetAnalogMode()      do { ANSELAbits.ANSA0 = 1; } while(0)
#define PLUS_SetDigitalMode()     do { ANSELAbits.ANSA0 = 0; } while(0)

// get/set MINUS aliases
#define MINUS_TRIS                 TRISAbits.TRISA1
#define MINUS_LAT                  LATAbits.LATA1
#define MINUS_PORT                 PORTAbits.RA1
#define MINUS_WPU                  WPUAbits.WPUA1
#define MINUS_OD                   ODCONAbits.ODCA1
#define MINUS_ANS                  ANSELAbits.ANSA1
#define MINUS_SetHigh()            do { LATAbits.LATA1 = 1; } while(0)
#define MINUS_SetLow()             do { LATAbits.LATA1 = 0; } while(0)
#define MINUS_Toggle()             do { LATAbits.LATA1 = ~LATAbits.LATA1; } while(0)
#define MINUS_GetValue()           PORTAbits.RA1
#define MINUS_SetDigitalInput()    do { TRISAbits.TRISA1 = 1; } while(0)
#define MINUS_SetDigitalOutput()   do { TRISAbits.TRISA1 = 0; } while(0)
#define MINUS_SetPullup()          do { WPUAbits.WPUA1 = 1; } while(0)
#define MINUS_ResetPullup()        do { WPUAbits.WPUA1 = 0; } while(0)
#define MINUS_SetPushPull()        do { ODCONAbits.ODCA1 = 0; } while(0)
#define MINUS_SetOpenDrain()       do { ODCONAbits.ODCA1 = 1; } while(0)
#define MINUS_SetAnalogMode()      do { ANSELAbits.ANSA1 = 1; } while(0)
#define MINUS_SetDigitalMode()     do { ANSELAbits.ANSA1 = 0; } while(0)

// get/set SELECT aliases
#define SELECT_TRIS                 TRISAbits.TRISA2
#define SELECT_LAT                  LATAbits.LATA2
#define SELECT_PORT                 PORTAbits.RA2
#define SELECT_WPU                  WPUAbits.WPUA2
#define SELECT_OD                   ODCONAbits.ODCA2
#define SELECT_ANS                  ANSELAbits.ANSA2
#define SELECT_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define SELECT_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define SELECT_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define SELECT_GetValue()           PORTAbits.RA2
#define SELECT_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define SELECT_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define SELECT_SetPullup()          do { WPUAbits.WPUA2 = 1; } while(0)
#define SELECT_ResetPullup()        do { WPUAbits.WPUA2 = 0; } while(0)
#define SELECT_SetPushPull()        do { ODCONAbits.ODCA2 = 0; } while(0)
#define SELECT_SetOpenDrain()       do { ODCONAbits.ODCA2 = 1; } while(0)
#define SELECT_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define SELECT_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set START aliases
#define START_TRIS                 TRISCbits.TRISC0
#define START_LAT                  LATCbits.LATC0
#define START_PORT                 PORTCbits.RC0
#define START_WPU                  WPUCbits.WPUC0
#define START_OD                   ODCONCbits.ODCC0
#define START_ANS                  ANSELCbits.ANSC0
#define START_SetHigh()            do { LATCbits.LATC0 = 1; } while(0)
#define START_SetLow()             do { LATCbits.LATC0 = 0; } while(0)
#define START_Toggle()             do { LATCbits.LATC0 = ~LATCbits.LATC0; } while(0)
#define START_GetValue()           PORTCbits.RC0
#define START_SetDigitalInput()    do { TRISCbits.TRISC0 = 1; } while(0)
#define START_SetDigitalOutput()   do { TRISCbits.TRISC0 = 0; } while(0)
#define START_SetPullup()          do { WPUCbits.WPUC0 = 1; } while(0)
#define START_ResetPullup()        do { WPUCbits.WPUC0 = 0; } while(0)
#define START_SetPushPull()        do { ODCONCbits.ODCC0 = 0; } while(0)
#define START_SetOpenDrain()       do { ODCONCbits.ODCC0 = 1; } while(0)
#define START_SetAnalogMode()      do { ANSELCbits.ANSC0 = 1; } while(0)
#define START_SetDigitalMode()     do { ANSELCbits.ANSC0 = 0; } while(0)

// get/set STOP aliases
#define STOP_TRIS                 TRISCbits.TRISC1
#define STOP_LAT                  LATCbits.LATC1
#define STOP_PORT                 PORTCbits.RC1
#define STOP_WPU                  WPUCbits.WPUC1
#define STOP_OD                   ODCONCbits.ODCC1
#define STOP_ANS                  ANSELCbits.ANSC1
#define STOP_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define STOP_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define STOP_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define STOP_GetValue()           PORTCbits.RC1
#define STOP_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define STOP_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)
#define STOP_SetPullup()          do { WPUCbits.WPUC1 = 1; } while(0)
#define STOP_ResetPullup()        do { WPUCbits.WPUC1 = 0; } while(0)
#define STOP_SetPushPull()        do { ODCONCbits.ODCC1 = 0; } while(0)
#define STOP_SetOpenDrain()       do { ODCONCbits.ODCC1 = 1; } while(0)
#define STOP_SetAnalogMode()      do { ANSELCbits.ANSC1 = 1; } while(0)
#define STOP_SetDigitalMode()     do { ANSELCbits.ANSC1 = 0; } while(0)

// get/set SSRCTL aliases
#define SSRCTL_TRIS                 TRISCbits.TRISC2
#define SSRCTL_LAT                  LATCbits.LATC2
#define SSRCTL_PORT                 PORTCbits.RC2
#define SSRCTL_WPU                  WPUCbits.WPUC2
#define SSRCTL_OD                   ODCONCbits.ODCC2
#define SSRCTL_ANS                  ANSELCbits.ANSC2
#define SSRCTL_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define SSRCTL_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define SSRCTL_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define SSRCTL_GetValue()           PORTCbits.RC2
#define SSRCTL_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define SSRCTL_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define SSRCTL_SetPullup()          do { WPUCbits.WPUC2 = 1; } while(0)
#define SSRCTL_ResetPullup()        do { WPUCbits.WPUC2 = 0; } while(0)
#define SSRCTL_SetPushPull()        do { ODCONCbits.ODCC2 = 0; } while(0)
#define SSRCTL_SetOpenDrain()       do { ODCONCbits.ODCC2 = 1; } while(0)
#define SSRCTL_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define SSRCTL_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set RC3 procedures
#define RC3_SetHigh()            do { LATCbits.LATC3 = 1; } while(0)
#define RC3_SetLow()             do { LATCbits.LATC3 = 0; } while(0)
#define RC3_Toggle()             do { LATCbits.LATC3 = ~LATCbits.LATC3; } while(0)
#define RC3_GetValue()              PORTCbits.RC3
#define RC3_SetDigitalInput()    do { TRISCbits.TRISC3 = 1; } while(0)
#define RC3_SetDigitalOutput()   do { TRISCbits.TRISC3 = 0; } while(0)
#define RC3_SetPullup()             do { WPUCbits.WPUC3 = 1; } while(0)
#define RC3_ResetPullup()           do { WPUCbits.WPUC3 = 0; } while(0)
#define RC3_SetAnalogMode()         do { ANSELCbits.ANSC3 = 1; } while(0)
#define RC3_SetDigitalMode()        do { ANSELCbits.ANSC3 = 0; } while(0)

// get/set SCL aliases
#define SCL_TRIS                 TRISCbits.TRISC4
#define SCL_LAT                  LATCbits.LATC4
#define SCL_PORT                 PORTCbits.RC4
#define SCL_WPU                  WPUCbits.WPUC4
#define SCL_OD                   ODCONCbits.ODCC4
#define SCL_ANS                  ANSELCbits.ANSC4
#define SCL_SetHigh()            do { LATCbits.LATC4 = 1; } while(0)
#define SCL_SetLow()             do { LATCbits.LATC4 = 0; } while(0)
#define SCL_Toggle()             do { LATCbits.LATC4 = ~LATCbits.LATC4; } while(0)
#define SCL_GetValue()           PORTCbits.RC4
#define SCL_SetDigitalInput()    do { TRISCbits.TRISC4 = 1; } while(0)
#define SCL_SetDigitalOutput()   do { TRISCbits.TRISC4 = 0; } while(0)
#define SCL_SetPullup()          do { WPUCbits.WPUC4 = 1; } while(0)
#define SCL_ResetPullup()        do { WPUCbits.WPUC4 = 0; } while(0)
#define SCL_SetPushPull()        do { ODCONCbits.ODCC4 = 0; } while(0)
#define SCL_SetOpenDrain()       do { ODCONCbits.ODCC4 = 1; } while(0)
#define SCL_SetAnalogMode()      do { ANSELCbits.ANSC4 = 1; } while(0)
#define SCL_SetDigitalMode()     do { ANSELCbits.ANSC4 = 0; } while(0)

// get/set SDA aliases
#define SDA_TRIS                 TRISCbits.TRISC5
#define SDA_LAT                  LATCbits.LATC5
#define SDA_PORT                 PORTCbits.RC5
#define SDA_WPU                  WPUCbits.WPUC5
#define SDA_OD                   ODCONCbits.ODCC5
#define SDA_ANS                  ANSELCbits.ANSC5
#define SDA_SetHigh()            do { LATCbits.LATC5 = 1; } while(0)
#define SDA_SetLow()             do { LATCbits.LATC5 = 0; } while(0)
#define SDA_Toggle()             do { LATCbits.LATC5 = ~LATCbits.LATC5; } while(0)
#define SDA_GetValue()           PORTCbits.RC5
#define SDA_SetDigitalInput()    do { TRISCbits.TRISC5 = 1; } while(0)
#define SDA_SetDigitalOutput()   do { TRISCbits.TRISC5 = 0; } while(0)
#define SDA_SetPullup()          do { WPUCbits.WPUC5 = 1; } while(0)
#define SDA_ResetPullup()        do { WPUCbits.WPUC5 = 0; } while(0)
#define SDA_SetPushPull()        do { ODCONCbits.ODCC5 = 0; } while(0)
#define SDA_SetOpenDrain()       do { ODCONCbits.ODCC5 = 1; } while(0)
#define SDA_SetAnalogMode()      do { ANSELCbits.ANSC5 = 1; } while(0)
#define SDA_SetDigitalMode()     do { ANSELCbits.ANSC5 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/