/**
 * PCB Board: dcmdrv
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.8
        Device            :  PIC16F18325
        Driver Version    :  2.00
*/


#include "mcc_generated_files/mcc.h"

uint8_t ten_ms_flag = 0;
uint8_t sw_cnt = 0;
uint8_t motor_on_flag = 0;
uint8_t over_current_flag = 0;

uint16_t v;
uint16_t temp;

uint16_t a_save[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint8_t a_save_p = 0;
uint16_t a;

uint16_t vr_save[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint8_t vr_save_p = 0;
uint16_t vr;

void ledg(uint16_t v){
    extern uint8_t motor_on_flag;
    static uint8_t ledg_cnt = 0;

    if (v < 2400){
        LEDG_SetHigh();
        motor_on_flag = 0;
    }
    else if (v <= 5000){
        ledg_cnt++;
        v -= 2400;
        v >>= 4;
        if (ledg_cnt < v) LEDG_SetLow();
        else  LEDG_SetHigh();
        if (ledg_cnt >= 162) ledg_cnt = 0;
    }
    else { // over voltage(> 5V)
        ledg_cnt++;
        motor_on_flag = 0;
        if (ledg_cnt < 15) LEDG_SetLow();
        else if (ledg_cnt < 30) LEDG_SetHigh();
        else ledg_cnt = 0;
    }
}

void ledr(uint16_t a){
    extern uint8_t motor_on_flag;
    extern uint8_t over_current_flag;
    static uint8_t ledr_cnt = 0;
    static uint8_t over_current_cnt = 0;

    ledr_cnt++;
    if (over_current_flag || over_current_cnt >= 50) { // over current > 2A,0.5sec
        motor_on_flag = 0;
        over_current_flag = 1;
        over_current_cnt = 0;
        if (ledr_cnt < 15) LEDR_SetLow();
        else if (ledr_cnt < 30) LEDR_SetHigh();
        else ledr_cnt = 0;
    }
    else if (a < 100){
        LEDR_SetHigh();
        over_current_cnt = 0;
    }
    else if (a <= 2000){
        over_current_cnt = 0;
        a >>= 4;
        if (ledr_cnt < a) LEDR_SetLow();
        else  LEDR_SetHigh();
        if (ledr_cnt > 125) ledr_cnt = 0;
    }
    else { // current > 2A
        over_current_cnt++;
        if (ledr_cnt < 15) LEDR_SetLow();
        else if (ledr_cnt < 30) LEDR_SetHigh();
        else ledr_cnt = 0;
    }
}

void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();

    while (1)
    {
        if (!ten_ms_flag){
            __delay_us(100);
            continue;
        }
        else{
            ten_ms_flag = 0;
        }
        
        // motor_on/off
        if (SW_GetValue()){
            sw_cnt = 0;
        }
        else{
            sw_cnt++;
            if (sw_cnt == 5){
                if (over_current_flag) over_current_flag = 0;
                else motor_on_flag ^= 1;
            }
        }
        
        // get battery voltage (mv)
        v = ADC_GetConversion(AD_V);
        v *= 57; // battery V = (47K+10K)/10K
        v /= 10;
        ledg(v);
    
        // get Motor current (mA)
        
        a_save[a_save_p] = ADC_GetConversion(AD_A);
        a_save_p++;
        if (a_save_p >=16) a_save_p = 0;
        temp = 0;
        for(uint8_t i=0;i<16;i++){
            temp += a_save[i];
        }
        temp >>= 3;
        a = temp * 5;
        ledr(a);
    
        // get PWM value fro Volume (0 to 1023)
        //vr = vr_p/vr_pr*1024
        temp =  ADC_GetConversion(AD_VR);
        temp <<= 6;
        temp /= ADC_GetConversion(AD_VRR);
        vr_save[vr_save_p] = temp;
        vr_save_p++;
        if (vr_save_p >=16) vr_save_p = 0;
        temp = 0;
        for(uint8_t i=0;i<16;i++){
            temp += vr_save[i];
        }
        vr = temp;
//        vr = ADC_GetConversion(AD_VR);
        //vr >>= 4; // get average (0 to 63)
        //vr <<= 4; // o to 1023 for PWM value

        if (motor_on_flag) PWM5_LoadDutyValue(vr);
        else PWM5_LoadDutyValue(0);
    
    // end of while loop
    }
}
/**
 End of File
*/