/**
  @Generated Pin Manager Header File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the Pin Manager file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  @Description
    This header file provides APIs for driver for .
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.8
        Device            :  PIC16F18325
        Driver Version    :  2.11
    The generated drivers are tested against the following:
        Compiler          :  XC8 2.36 and above
        MPLAB 	          :  MPLAB X 6.00	
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#ifndef PIN_MANAGER_H
#define PIN_MANAGER_H

/**
  Section: Included Files
*/

#include <xc.h>

#define INPUT   1
#define OUTPUT  0

#define HIGH    1
#define LOW     0

#define ANALOG      1
#define DIGITAL     0

#define PULL_UP_ENABLED      1
#define PULL_UP_DISABLED     0

// get/set LEDR aliases
#define LEDR_TRIS                 TRISAbits.TRISA2
#define LEDR_LAT                  LATAbits.LATA2
#define LEDR_PORT                 PORTAbits.RA2
#define LEDR_WPU                  WPUAbits.WPUA2
#define LEDR_OD                   ODCONAbits.ODCA2
#define LEDR_ANS                  ANSELAbits.ANSA2
#define LEDR_SetHigh()            do { LATAbits.LATA2 = 1; } while(0)
#define LEDR_SetLow()             do { LATAbits.LATA2 = 0; } while(0)
#define LEDR_Toggle()             do { LATAbits.LATA2 = ~LATAbits.LATA2; } while(0)
#define LEDR_GetValue()           PORTAbits.RA2
#define LEDR_SetDigitalInput()    do { TRISAbits.TRISA2 = 1; } while(0)
#define LEDR_SetDigitalOutput()   do { TRISAbits.TRISA2 = 0; } while(0)
#define LEDR_SetPullup()          do { WPUAbits.WPUA2 = 1; } while(0)
#define LEDR_ResetPullup()        do { WPUAbits.WPUA2 = 0; } while(0)
#define LEDR_SetPushPull()        do { ODCONAbits.ODCA2 = 0; } while(0)
#define LEDR_SetOpenDrain()       do { ODCONAbits.ODCA2 = 1; } while(0)
#define LEDR_SetAnalogMode()      do { ANSELAbits.ANSA2 = 1; } while(0)
#define LEDR_SetDigitalMode()     do { ANSELAbits.ANSA2 = 0; } while(0)

// get/set SW aliases
#define SW_TRIS                 TRISAbits.TRISA4
#define SW_LAT                  LATAbits.LATA4
#define SW_PORT                 PORTAbits.RA4
#define SW_WPU                  WPUAbits.WPUA4
#define SW_OD                   ODCONAbits.ODCA4
#define SW_ANS                  ANSELAbits.ANSA4
#define SW_SetHigh()            do { LATAbits.LATA4 = 1; } while(0)
#define SW_SetLow()             do { LATAbits.LATA4 = 0; } while(0)
#define SW_Toggle()             do { LATAbits.LATA4 = ~LATAbits.LATA4; } while(0)
#define SW_GetValue()           PORTAbits.RA4
#define SW_SetDigitalInput()    do { TRISAbits.TRISA4 = 1; } while(0)
#define SW_SetDigitalOutput()   do { TRISAbits.TRISA4 = 0; } while(0)
#define SW_SetPullup()          do { WPUAbits.WPUA4 = 1; } while(0)
#define SW_ResetPullup()        do { WPUAbits.WPUA4 = 0; } while(0)
#define SW_SetPushPull()        do { ODCONAbits.ODCA4 = 0; } while(0)
#define SW_SetOpenDrain()       do { ODCONAbits.ODCA4 = 1; } while(0)
#define SW_SetAnalogMode()      do { ANSELAbits.ANSA4 = 1; } while(0)
#define SW_SetDigitalMode()     do { ANSELAbits.ANSA4 = 0; } while(0)

// get/set LEDG aliases
#define LEDG_TRIS                 TRISAbits.TRISA5
#define LEDG_LAT                  LATAbits.LATA5
#define LEDG_PORT                 PORTAbits.RA5
#define LEDG_WPU                  WPUAbits.WPUA5
#define LEDG_OD                   ODCONAbits.ODCA5
#define LEDG_ANS                  ANSELAbits.ANSA5
#define LEDG_SetHigh()            do { LATAbits.LATA5 = 1; } while(0)
#define LEDG_SetLow()             do { LATAbits.LATA5 = 0; } while(0)
#define LEDG_Toggle()             do { LATAbits.LATA5 = ~LATAbits.LATA5; } while(0)
#define LEDG_GetValue()           PORTAbits.RA5
#define LEDG_SetDigitalInput()    do { TRISAbits.TRISA5 = 1; } while(0)
#define LEDG_SetDigitalOutput()   do { TRISAbits.TRISA5 = 0; } while(0)
#define LEDG_SetPullup()          do { WPUAbits.WPUA5 = 1; } while(0)
#define LEDG_ResetPullup()        do { WPUAbits.WPUA5 = 0; } while(0)
#define LEDG_SetPushPull()        do { ODCONAbits.ODCA5 = 0; } while(0)
#define LEDG_SetOpenDrain()       do { ODCONAbits.ODCA5 = 1; } while(0)
#define LEDG_SetAnalogMode()      do { ANSELAbits.ANSA5 = 1; } while(0)
#define LEDG_SetDigitalMode()     do { ANSELAbits.ANSA5 = 0; } while(0)

// get/set AD_A aliases
#define AD_A_TRIS                 TRISCbits.TRISC1
#define AD_A_LAT                  LATCbits.LATC1
#define AD_A_PORT                 PORTCbits.RC1
#define AD_A_WPU                  WPUCbits.WPUC1
#define AD_A_OD                   ODCONCbits.ODCC1
#define AD_A_ANS                  ANSELCbits.ANSC1
#define AD_A_SetHigh()            do { LATCbits.LATC1 = 1; } while(0)
#define AD_A_SetLow()             do { LATCbits.LATC1 = 0; } while(0)
#define AD_A_Toggle()             do { LATCbits.LATC1 = ~LATCbits.LATC1; } while(0)
#define AD_A_GetValue()           PORTCbits.RC1
#define AD_A_SetDigitalInput()    do { TRISCbits.TRISC1 = 1; } while(0)
#define AD_A_SetDigitalOutput()   do { TRISCbits.TRISC1 = 0; } while(0)
#define AD_A_SetPullup()          do { WPUCbits.WPUC1 = 1; } while(0)
#define AD_A_ResetPullup()        do { WPUCbits.WPUC1 = 0; } while(0)
#define AD_A_SetPushPull()        do { ODCONCbits.ODCC1 = 0; } while(0)
#define AD_A_SetOpenDrain()       do { ODCONCbits.ODCC1 = 1; } while(0)
#define AD_A_SetAnalogMode()      do { ANSELCbits.ANSC1 = 1; } while(0)
#define AD_A_SetDigitalMode()     do { ANSELCbits.ANSC1 = 0; } while(0)

// get/set PWM aliases
#define PWM_TRIS                 TRISCbits.TRISC2
#define PWM_LAT                  LATCbits.LATC2
#define PWM_PORT                 PORTCbits.RC2
#define PWM_WPU                  WPUCbits.WPUC2
#define PWM_OD                   ODCONCbits.ODCC2
#define PWM_ANS                  ANSELCbits.ANSC2
#define PWM_SetHigh()            do { LATCbits.LATC2 = 1; } while(0)
#define PWM_SetLow()             do { LATCbits.LATC2 = 0; } while(0)
#define PWM_Toggle()             do { LATCbits.LATC2 = ~LATCbits.LATC2; } while(0)
#define PWM_GetValue()           PORTCbits.RC2
#define PWM_SetDigitalInput()    do { TRISCbits.TRISC2 = 1; } while(0)
#define PWM_SetDigitalOutput()   do { TRISCbits.TRISC2 = 0; } while(0)
#define PWM_SetPullup()          do { WPUCbits.WPUC2 = 1; } while(0)
#define PWM_ResetPullup()        do { WPUCbits.WPUC2 = 0; } while(0)
#define PWM_SetPushPull()        do { ODCONCbits.ODCC2 = 0; } while(0)
#define PWM_SetOpenDrain()       do { ODCONCbits.ODCC2 = 1; } while(0)
#define PWM_SetAnalogMode()      do { ANSELCbits.ANSC2 = 1; } while(0)
#define PWM_SetDigitalMode()     do { ANSELCbits.ANSC2 = 0; } while(0)

// get/set AD_V aliases
#define AD_V_TRIS                 TRISCbits.TRISC3
#define AD_V_LAT                  LATCbits.LATC3
#define AD_V_PORT                 PORTCbits.RC3
#define AD_V_WPU                  WPUCbits.WPUC3
#define AD_V_OD                   ODCONCbits.ODCC3
#define AD_V_ANS                  ANSELCbits.ANSC3
#define AD_V_SetHigh()            do { LATCbits.LATC3 = 1; } while(0)
#define AD_V_SetLow()             do { LATCbits.LATC3 = 0; } while(0)
#define AD_V_Toggle()             do { LATCbits.LATC3 = ~LATCbits.LATC3; } while(0)
#define AD_V_GetValue()           PORTCbits.RC3
#define AD_V_SetDigitalInput()    do { TRISCbits.TRISC3 = 1; } while(0)
#define AD_V_SetDigitalOutput()   do { TRISCbits.TRISC3 = 0; } while(0)
#define AD_V_SetPullup()          do { WPUCbits.WPUC3 = 1; } while(0)
#define AD_V_ResetPullup()        do { WPUCbits.WPUC3 = 0; } while(0)
#define AD_V_SetPushPull()        do { ODCONCbits.ODCC3 = 0; } while(0)
#define AD_V_SetOpenDrain()       do { ODCONCbits.ODCC3 = 1; } while(0)
#define AD_V_SetAnalogMode()      do { ANSELCbits.ANSC3 = 1; } while(0)
#define AD_V_SetDigitalMode()     do { ANSELCbits.ANSC3 = 0; } while(0)

// get/set AD_VR aliases
#define AD_VR_TRIS                 TRISCbits.TRISC4
#define AD_VR_LAT                  LATCbits.LATC4
#define AD_VR_PORT                 PORTCbits.RC4
#define AD_VR_WPU                  WPUCbits.WPUC4
#define AD_VR_OD                   ODCONCbits.ODCC4
#define AD_VR_ANS                  ANSELCbits.ANSC4
#define AD_VR_SetHigh()            do { LATCbits.LATC4 = 1; } while(0)
#define AD_VR_SetLow()             do { LATCbits.LATC4 = 0; } while(0)
#define AD_VR_Toggle()             do { LATCbits.LATC4 = ~LATCbits.LATC4; } while(0)
#define AD_VR_GetValue()           PORTCbits.RC4
#define AD_VR_SetDigitalInput()    do { TRISCbits.TRISC4 = 1; } while(0)
#define AD_VR_SetDigitalOutput()   do { TRISCbits.TRISC4 = 0; } while(0)
#define AD_VR_SetPullup()          do { WPUCbits.WPUC4 = 1; } while(0)
#define AD_VR_ResetPullup()        do { WPUCbits.WPUC4 = 0; } while(0)
#define AD_VR_SetPushPull()        do { ODCONCbits.ODCC4 = 0; } while(0)
#define AD_VR_SetOpenDrain()       do { ODCONCbits.ODCC4 = 1; } while(0)
#define AD_VR_SetAnalogMode()      do { ANSELCbits.ANSC4 = 1; } while(0)
#define AD_VR_SetDigitalMode()     do { ANSELCbits.ANSC4 = 0; } while(0)

// get/set AD_VRR aliases
#define AD_VRR_TRIS                 TRISCbits.TRISC5
#define AD_VRR_LAT                  LATCbits.LATC5
#define AD_VRR_PORT                 PORTCbits.RC5
#define AD_VRR_WPU                  WPUCbits.WPUC5
#define AD_VRR_OD                   ODCONCbits.ODCC5
#define AD_VRR_ANS                  ANSELCbits.ANSC5
#define AD_VRR_SetHigh()            do { LATCbits.LATC5 = 1; } while(0)
#define AD_VRR_SetLow()             do { LATCbits.LATC5 = 0; } while(0)
#define AD_VRR_Toggle()             do { LATCbits.LATC5 = ~LATCbits.LATC5; } while(0)
#define AD_VRR_GetValue()           PORTCbits.RC5
#define AD_VRR_SetDigitalInput()    do { TRISCbits.TRISC5 = 1; } while(0)
#define AD_VRR_SetDigitalOutput()   do { TRISCbits.TRISC5 = 0; } while(0)
#define AD_VRR_SetPullup()          do { WPUCbits.WPUC5 = 1; } while(0)
#define AD_VRR_ResetPullup()        do { WPUCbits.WPUC5 = 0; } while(0)
#define AD_VRR_SetPushPull()        do { ODCONCbits.ODCC5 = 0; } while(0)
#define AD_VRR_SetOpenDrain()       do { ODCONCbits.ODCC5 = 1; } while(0)
#define AD_VRR_SetAnalogMode()      do { ANSELCbits.ANSC5 = 1; } while(0)
#define AD_VRR_SetDigitalMode()     do { ANSELCbits.ANSC5 = 0; } while(0)

/**
   @Param
    none
   @Returns
    none
   @Description
    GPIO and peripheral I/O initialization
   @Example
    PIN_MANAGER_Initialize();
 */
void PIN_MANAGER_Initialize (void);

/**
 * @Param
    none
 * @Returns
    none
 * @Description
    Interrupt on Change Handling routine
 * @Example
    PIN_MANAGER_IOC();
 */
void PIN_MANAGER_IOC(void);



#endif // PIN_MANAGER_H
/**
 End of File
*/